/*---------------------------------------------------------
  Q1HzTĲo_AC30Ū@DHT11AܦbTM1637WA
  ózLCeESP-01oeŷëצܺAC

   2024/05/04
----------------------------------------------------------*/
#include <reg51.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <intrins.h>
#include <uart.h>

#define  limit 30   //time inteval for send data to ESP-01

//Define TM1637 port
sbit clk = P1^3;
sbit dio = P1^1;

sbit BUILTIN_LED  = P1^4;  //LED
  
const unsigned char code seg_data[18] =   //TM1637 Fonts
{
     0x3F, // 0
     0x06, // 1
     0x5B, // 2
     0x4F, // 3
     0x66, // 4
     0x6D, // 5
     0x7D, // 6
     0x07, // 7
     0x7F, // 8
     0x6F, // 9 
     0x00, // none  10
     0x03, // :     11
     0x04, // .     12
     0x79, // E     13
     0x50, // r     14
     0x39, // C     15
     0x76, // H     16
     0x02  // .     17   _UI
 }; 

//================= DHT11 Functions =====================================
sbit DHT11 = P1^0;		// Connect DHT11 output Pin to P1.0 Pin 

//xdata׹rOܧ⦹ܼƩb~RAM
xdata int I_RH, D_RH, I_Temp, D_Temp, CheckSum; 
xdata int num[5];

void delay_1ms()
{
    TMOD = 0x01;
    TH0 = 0xFC;
    TL0 = 0x67;
    TR0 = 1;
    while(TF0 == 0);
    TR0 = 0;
    TF0 = 0;   
}

void delay_ms(int n)
{
    int i;
    for(i=0; i<n; i++)
        delay_1ms();
}
 
void timer_delay20ms()		// Timer0 delay function 
{
	TMOD = 0x01;
	TH0 = 0xB8;		// Load higher 8-bit in TH0 
	TL0 = 0x0C;		// Load lower 8-bit in TL0 
	TR0 = 1;		// Start timer0 
	while(TF0 == 0);	// Wait until timer0 flag set 
	TR0 = 0;		// Stop timer0 
	TF0 = 0;		// Clear timer0 flag 
}

void timer_delay30us()		// Timer0 delay function
{
	TMOD = 0x01;		// Timer0 mode1 (16-bit timer mode) 
	TH0 = 0xFF;		// Load higher 8-bit in TH0 
	TL0 = 0xF1;		// Load lower 8-bit in TL0 
	TR0 = 1;		// Start timer0 
	while(TF0 == 0);	// Wait until timer0 flag set 
	TR0 = 0;		// Stop timer0 
	TF0 = 0;		// Clear timer0 flag 
}

void Request()			// Microcontroller send request 
{
	DHT11 = 0;		// set to low pin 
	timer_delay20ms();	// wait for 20ms 
	DHT11 = 1;		// set to high pin 
}

void Response()			// Receive response from DHT11 
{
	while(DHT11 == 1);
	while(DHT11 == 0);
	while(DHT11 == 1);
}

int Receive_data()		// Receive data 
{
	int q,c = 0;	
	for (q=0; q<8; q++)
	{
		while(DHT11 == 0);    // check received bit 0 or 1 
		timer_delay30us();
		if(DHT11 == 1)	    // If high pulse is greater than 30ms 
		  c = (c << 1) | (0x01);   // Then its logic HIGH 
		else		// otherwise its logic LOW 
		  c = (c << 1);
		while(DHT11 == 1);
	}
	return c;
}
//============== 1Hz ==============================================
xdata unsigned char ex0_isr_counter = 0;

void ex0_isr(void) interrupt 0
{
    ex0_isr_counter++;   // Increment the counter
}

//=============== TM1637 Functions ================================
void Delay_us (unsigned int i) // n us delay
{
   for (; i> 0; i--)
     nop_ ();
}

void I2CStart (void) // 1637 start
{
   clk = 1;
   dio = 1;
   Delay_us (2);
   dio = 0;
}

void I2Cask (void) // 1637 Answer
{
   clk = 0;
   Delay_us (5); // After the falling edge of the eighth clock delay 5us, 
                 // ACK signals the beginning of judgment
   while (dio);
   clk = 1;
   Delay_us (2);
   clk = 0;
}

void I2CStop (void) // 1637 Stop
{
   clk = 0;
   Delay_us (2);
   dio = 0;
   Delay_us (2);
   clk = 1;
   Delay_us (2);
   dio = 1;
}

void I2CWrByte (unsigned char oneByte) // write a byte
{
   xdata unsigned char i;
   for (i = 0; i <8; i++)
   {
      clk = 0;
      if (oneByte & 0x01)   // low front
        {dio = 1;}
      else 
        {dio = 0;}
      Delay_us (3);
      oneByte = oneByte >> 1;
      clk = 1;
      Delay_us (3);
   }
}
// key buttom not use in this program
/*
unsigned char ScanKey(void) // read buttons 
{
   xdata unsigned char rekey, rkey, i;
   I2CStart ();
   I2CWrByte (0x42); // read command buttons
   I2Cask ();
   dio = 1; // read keys before data lines pulled
   for (i = 0; i <8; i++) // start reading from the low
   {
      clk = 0;
      rekey = rekey >> 1;
      Delay_us(30);
      clk=1;
      if(dio)
      {
          rekey=rekey|0x80;
      }
      else
      {
          rekey=rekey|0x00;
      }
      Delay_us(30);
   }
   I2Cask();
   I2CStop();
   return (rekey);
}

void SmgDisplay(void) // Write display register
{
   xdata unsigned char i;
   I2CStart();
   I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 
                    //44H fixed address mode
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0xc0); // Set the first address
   I2Cask();
   for(i=0;i<4;i++) // Addresses from Canada, do not always write address
   {
      I2CWrByte(seg_data[i]); // Send data
      I2Cask();
   }
   I2CStop();
   I2CStart();
   I2CWrByte(0x8f); // Open display, maximum brightness
   I2Cask();
   I2CStop();
}
*/
void DisplayNum(int num[5]) // Write display register
{
   xdata unsigned char i; 
   I2CStart();
   I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 
                    //44H fixed address mode
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0xC0); // Set the address, 0xC0 is first
   I2Cask();
   for(i=0;i<5;i++) // Addresses from Canada, do not always write address
   {
      I2CWrByte(seg_data[num[i]]); // Send data
      I2Cask();
   }
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0x8f); // Open display, maximum brightness
   I2Cask();
   I2CStop();
}

void showdata()
{
    //show temp and humi data on TM1637-----------------------------
    num[0] = 17;
    num[1] = (int)(I_Temp / 10);
    num[2] = I_Temp % 10;
    num[3] = (int)(D_Temp / 10);
    num[4] = 15;  //C
    DisplayNum(num);
    delay_ms(5000);
    num[0] = 17;
    num[1] = (int)(I_RH / 10);
    num[2] = I_RH % 10;
    num[3] = (int)(D_RH / 10);
    num[4] = 16;  //H
    DisplayNum(num);
    delay_ms(5000);   
}

//================ MAIN ======================================
void main()
{ 
    xdata char da[5];

    SP = 0x60;
    IT0 = 1;   // Configure interrupt 0 for falling edge on /INT0 (P3.2)
    EX0 = 1;   // Enable EX0 Interrupt
    EA = 1;    // Enable Global Interrupt Flag
    
    BUILTIN_LED = 0x01;
    
	while(1)
	{		
		Request();	// send start pulse 
		Response();	// receive response 
		
		I_RH = Receive_data();	// store first eight bit in I_RH 
		D_RH = Receive_data();	// store next eight bit in D_RH 
		I_Temp = Receive_data();	// store next eight bit in I_Temp 
		D_Temp = Receive_data();	// store next eight bit in D_Temp 
		CheckSum = Receive_data();// store next eight bit in CheckSum 

        if ((I_RH + D_RH + I_Temp + D_Temp) != CheckSum)
        {
			//Tubծɥ~@RS232ҲջPPCqɥ
            UART_Printf("DHT11 Error");  
        }
        else
        {                               
            if(ex0_isr_counter >= limit)
            { 
                //UART  sand data -------------------------------
                ex0_isr_counter = 0;
                UART_Init(9600);
                BUILTIN_LED = 0x00;   //LED ON
                da[0] = 0x30 | (int)(I_Temp/ 10);
                da[1] = 0x30 | I_Temp % 10;
                da[2] = '.';
                da[3] = 0x30 | (int)(D_Temp / 10);    
                da[4] = '\0';                               
                UART_TxString(da);
                
                delay_ms(500);
                
                UART_Init(9600);
                da[0] = 0x30 | (int)(I_RH/ 10);
                da[1] = 0x30 | I_RH % 10;
                da[2] = '.';
                da[3] = 0x30 | (int)(D_RH / 10);  
                da[4] = '\0';                               
                UART_TxString(da);
                BUILTIN_LED = 0x01;  //LED OFF
            }
            else
            {
                showdata();
            }
        }
    }	
}
